{{

This program demonstrates how the RealRandom object
can generate a random number on each power-up. It also
conveys continuous random numbers to the headphones
for listening -- be warned, it is loud whitenoise.

It uses the Propeller Demo Board, or any equivalent
TV and audio circuits on a raw Propeller.

}}

CON

  _clkmode = xtal1 + pll16x
  _xinfreq = 5_000_000


OBJ

  text  : "tv_text"
  rr    : "RealRandom"
  

PUB start | i

  'start RealRandom
  rr.start

  'start terminal and show a random number
  text.start(12)
  text.str(string(10,16,11,6))
  text.hex(rr.random, 8)
                                         
  'output the random numbers' lsb's to headphones
  i := rr.random_ptr 
  dira[11..10]~~
  repeat
    outa[11..10] := long[i]